#ifndef AC2DEC_GLOBALS_H
#define AC2DEC_GLOBALS_H

#ifndef AC3DECODER_DOUBLE
typedef float sample_t;
#else
typedef double sample_t;
#endif


typedef signed char int8_t;
typedef signed short int16_t;
typedef signed int int32_t;
#ifdef ARCH_X86
  typedef signed long long int64_t;
#endif

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
#ifdef ARCH_X86
  typedef unsigned long long uint64_t;
#endif

typedef struct 
{
  uint8_t bai;      // fine SNR offset, fast gain
  uint8_t deltbae;  // delta bit allocation exists
  int8_t deltba[50];// per-band delta bit allocation
} ba_t;

typedef struct 
{
  uint8_t exp[256]; // decoded channel exponents
  int8_t bap[256];  // derived channel bit allocation
} expbap_t;

typedef struct 
{
  sample_t q1[2];
  sample_t q2[2];
  sample_t q4;
  int q1_ptr;
  int q2_ptr;
  int q4_ptr;
} quantizer_t;

#define NCHANNELS    6
typedef sample_t sample_buffer_t[NCHANNELS][256];

typedef struct a52_state_s 
{
  uint8_t fscod;        // sample rate
  uint8_t halfrate;     // halfrate factor
//  uint8_t acmod;        // coded channels
//  uint8_t lfeon;        // coded lfe channel
//  sample_t clev;        // centre channel mix level
//  sample_t slev;        // surround channels mix level

//  int output;           // type of output
  sample_t level;       // output level
//  sample_t bias;        // output bias

//  int dynrnge;          // apply dynamic range
//  sample_t dynrng;      // dynamic range
//  void * dynrngdata;    // dynamic range callback funtion and data
//  sample_t (* dynrngcall) (sample_t range, void * dynrngdata);

  uint8_t chincpl;      // channel coupled
  uint8_t phsflginu;    // phase flags in use (stereo only)
  uint8_t cplstrtmant;  // coupling channel start mantissa
  uint8_t cplendmant;   // coupling channel end mantissa
  uint32_t cplbndstrc;  // coupling band structure
  sample_t cplco[5][18];// coupling coordinates

  // derived information
  uint8_t cplstrtbnd;   // coupling start band (for bit allocation)
  uint8_t ncplbnd;      // number of coupling bands

  uint8_t rematflg;     // stereo rematrixing

  uint8_t endmant[5];   // channel end mantissa

  uint16_t bai;         // bit allocation information

  uint8_t csnroffst;    // coarse SNR offset
  ba_t cplba;           // coupling bit allocation parameters
  ba_t ba[5];           // channel bit allocation parameters
  ba_t lfeba;           // lfe bit allocation parameters

  uint8_t cplfleak;     // coupling fast leak init
  uint8_t cplsleak;     // coupling slow leak init

  expbap_t cpl_expbap;
  expbap_t fbw_expbap[5];
  expbap_t lfe_expbap;
   
//  sample_t * samples;
//  int downmixed;
} a52_state_t;

#define LEVEL_PLUS6DB 2.0
#define LEVEL_PLUS3DB 1.4142135623730951
#define LEVEL_3DB 0.7071067811865476
#define LEVEL_45DB 0.5946035575013605
#define LEVEL_6DB 0.5

#define EXP_REUSE (0)
#define EXP_D15   (1)
#define EXP_D25   (2)
#define EXP_D45   (3)

#define DELTA_BIT_REUSE (0)
#define DELTA_BIT_NEW (1)
#define DELTA_BIT_NONE (2)
#define DELTA_BIT_RESERVED (3)

/*
#define A52_CHANNEL 0
#define A52_MONO 1
#define A52_STEREO 2
#define A52_3F 3
#define A52_2F1R 4
#define A52_3F1R 5
#define A52_2F2R 6
#define A52_3F2R 7
#define A52_CHANNEL1 8
#define A52_CHANNEL2 9
#define A52_DOLBY 10
#define A52_CHANNEL_MASK 15

#define A52_LFE 16
#define A52_ADJUST_LEVEL 32
*/

// channel names
#define CH_L         0  // Left channel
#define CH_C         1  // Center channel
#define CH_R         2  // Right channel
#define CH_SL        3  // Surround left channel
#define CH_SR        4  // Surround right channel
#define CH_LFE       5  // LFE channel

#define CH_M         1  // Mono channel = center channel
#define CH_CH1       0  // Channel 1 in Dual mono mode
#define CH_CH2       1  // Channel 2 in Dual mono mode
#define CH_S         3  // Surround channel = Left surround channel

// channel masks
#define CH_MASK_L    1
#define CH_MASK_C    2
#define CH_MASK_R    4
#define CH_MASK_SL   8
#define CH_MASK_SR   16
#define CH_MASK_LFE  32
#define CH_MASK_LAST 32

#define CH_MASK_M   4
#define CH_MASK_C1  0
#define CH_MASK_C2  2
#define CH_MASK_S   8
#define CH_MASK(ch) (1 << (ch))

// coding modes == A52/A standart modes
#define MODE_DUAL   0
#define MODE_1_0    1
#define MODE_2_0    2
#define MODE_3_0    3
#define MODE_2_1    4
#define MODE_3_1    5
#define MODE_2_2    6
#define MODE_3_2    7

// can be combined with any mode
#define MODE_LFE    8
// can be combined with 2/0 mode
#define MODE_DOLBY  16

// mode synonyms
#define MODE_MONO   1
#define MODE_STEREO 2
#define MODE_QUADRO 6


typedef uint8_t acmod_t;
typedef uint8_t channels_t;

const channels_t _mode_ch[8] =
{
  CH_MASK_C1 | CH_MASK_C2,
  CH_MASK_M,
  CH_MASK_L  | CH_MASK_R,
  CH_MASK_L  | CH_MASK_C | CH_MASK_R,
  CH_MASK_L  | CH_MASK_R | CH_MASK_S,
  CH_MASK_L  | CH_MASK_C | CH_MASK_R  | CH_MASK_S,
  CH_MASK_L  | CH_MASK_R | CH_MASK_SL | CH_MASK_SR,
  CH_MASK_L  | CH_MASK_C | CH_MASK_R  | CH_MASK_SL | CH_MASK_SR,
};

const int _mode_nfchans[8] = { 2, 1, 2, 3, 3, 4, 4, 5 };
const int _mode_nfront[8]  = { 2, 1, 2, 3, 2, 3, 2, 3 };
const int _mode_nrear[8]   = { 0, 0, 0, 0, 1, 1, 2, 2 };

// mode macros
#define IS_MODE_SURROUND(mode) ((mode) & 4)
#define IS_MODE_DOLBY(mode)    ((mode) & MODE_DOLBY)
#define IS_MODE_LFE(mode)      ((mode) & MODE_LFE)
#define MODE_ACMOD(mode)       ((mode)&7)
#define MODE_CH(mode)          (_mode_ch[(mode)&7] | (IS_MODE_LFE(mode)? CH_MASK_LFE: 0))
#define MODE_NFCHANS(mode)     (_mode_nfchans[(mode)&7])
#define MODE_NFRONT(mode)      (_mode_nfront[(mode)&7])
#define MODE_NREAR(mode)       (_mode_nrear[(mode)&7])
//#define NFCHAN2CH(nfchan,mode) ((nfchan)? (nfchan)+(~(mode)&1): 0)


#endif
