#ifndef AC3DEC_H
#define AC3DEC_H


#include "ac3dec_globals.h"
#include "imdct.h"
#include "mixer.h"
#include "bitstream.h"

////////////////////decoder///////////////////////////////

class BSI
{
public:
  int      famesize;    // frame size code
  int      rate;        // sample rate
  int      bitrate;     // bitrate

  uint8_t  halfrate;    // halfrate flag
  uint8_t  bsid;        // bit stream identification
  acmod_t  acmod;       // audio coding mode (modif)
  uint8_t  cmixlev;     // center mix level code
  uint8_t  surmixlev;   // surround mix level code
  uint8_t  lfeon;       // LFE if on

  uint8_t  dialnorm;    // dialog normalization 
  uint8_t  compre;      // compression gain word exists
  uint8_t  compr;       // compression gain word
  uint8_t  langcode;    // language code exists
  uint8_t  langcod;     // language code
  uint8_t  audprodie;   // audio production information exists
  uint8_t  mixlevel;    // mixing level (SPL)
  uint8_t  roomtyp;     // room type
                        
  uint8_t  dialnorm2;   // dialog normalization 
  uint8_t  compr2e;     // compression gain word exists
  uint8_t  compr2;      // compression gain word
  uint8_t  langcod2e;   // language code exists
  uint8_t  langcod2;    // language code
  uint8_t  audprodi2e;  // audio production information exists
  uint8_t  mixlevel2;   // mixing level (SPL)
  uint8_t  roomtyp2;    // room type

  uint8_t  copyrightb;  // copyright bit
  uint8_t  origbs;      // original bitstream

  struct {
    int hours;
    int mins;
    int secs;
    int frames;
    int fracs;
  } timecode;           // timecode

  bool     dynrnge;     // dynamic range gain word exists
  sample_t dynrng;      // dynamic range gain word
  bool     dynrng2e;    // dynamic range gain word exists
  sample_t dynrng2;     // dynamic range gain word

  int      sample_rate; // sample_rate
  int      bitrate;     // bitrate
};


class CAC3Parser
{
};





class CAC3Decoder
{
protected:
  // bsi
  uint8_t  bsid;       // bit stream identification
  acmod_t  acmod;      // audio coding mode
  sample_t clev;       // center mix level
  sample_t slev;       // surround mix level
  uint8_t  lfeon;      // LFE if on
  int      sample_rate;// sample_rate
  int      bitrate;    // bitrate

  // block
  bool     dynrnge;    // dynamic range compression exists
  sample_t dynrng_gain;// dynamic range gain


  a52_state_t * state;

  // data processing
  CIMDCT     imdct;
  CBitstream bitstream;
  // source buffers
  uint8_t  buf[3840];           // ac3 frame buffer
  uint8_t *bufptr;              // current data pointer
  uint8_t *bufpos;              // required data pointer
  // dest buffers
  sample_buffer_t  samples;
  sample_buffer_t  samples1;

  // mixer
  CMixer   mixer;

  acmod_t  acmod_out;  // output audio coding mode
  sample_t level;      // signal level
  sample_t bias;       // signal bias


  CAC3Decoder();
  ~CAC3Decoder();

  void reset(acmod_t acmod_out, const int ch_order[NCHANNELS], sample_t _level = 1.0, sample_t _bias = 0.0);

  // parser
  int parse_exponents (int expstr, int ngrps, uint8_t exponent, uint8_t * dest);
  int parse_deltba(int8_t * deltba);
  inline int zero_snr_offsets (int nfchans, a52_state_t * state);
  inline int16_t dither_gen (void);
  void coeff_get (sample_t * coeff, expbap_t * expbap, quantizer_t * quantizer, int dither, int end);
  void coeff_get_coupling (int nfchans, quantizer_t * quantizer, uint8_t dithflag[5]);

  int syncinfo (uint8_t * buf);
  int frame    (uint8_t * buf);
  int parse_block();
  
  // push buffer to decoder
  void decode(uint8_t *buffer, uint32_t length);
  // called when frame is ready
  virtual void block(sample_buffer_t samples) = 0;

public:
  bool dynrng;
};


#endif