#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "registry.h"

RegistryKey::RegistryKey(LPCTSTR name)
{
  key = 0;
  if (name)
    if (RegOpenKeyEx(HKEY_CURRENT_USER, name, 0, KEY_READ | KEY_WRITE, &key) != ERROR_SUCCESS)
      key = 0;
}

RegistryKey::~RegistryKey()
{
  if (key)
    RegCloseKey(key);
}

bool 
RegistryKey::create_key(LPCTSTR path, LPCTSTR name)
{
  if (RegOpenKeyEx(HKEY_CURRENT_USER, path, 0, KEY_READ | KEY_WRITE | KEY_CREATE_SUB_KEY, &key) != ERROR_SUCCESS)
  {
    key = 0;
    return false;
  }

  HKEY new_key;
  DWORD disposition;
  if (RegCreateKeyEx(key, name, NULL, "", REG_OPTION_NON_VOLATILE, KEY_READ | KEY_WRITE, NULL, &new_key, &disposition))
  {
    RegCloseKey(key);
    key = 0;
    return false;
  }

  RegCloseKey(key);
  key = new_key;
  return true;
}



bool 
RegistryKey::get_bool(LPCTSTR name, bool def)
{
  if (!key) return def;

  DWORD value, type, buf_len;
  value = 0;
  buf_len = 4;

  if (RegQueryValueEx(key, name, NULL, &type, (LPBYTE)&value, &buf_len) != ERROR_SUCCESS)
    return def;

  if (type != REG_DWORD)
    return def;

  return value != 0;
}

int32_t 
RegistryKey::get_int32(LPCTSTR name, int32_t def)
{
  if (!key) return def;

  DWORD value, type, buf_len;
  value = 0;
  buf_len = 4;

  if (RegQueryValueEx(key, name, NULL, &type, (LPBYTE)&value, &buf_len) != ERROR_SUCCESS)
    return def;

  if (type != REG_DWORD)
    return def;

  return value;
}

double 
RegistryKey::get_double(LPCTSTR name, double def)
{
  if (!key) return def;

  DWORD type, buf_len;
  char value[256];
  char *stopstr;
  buf_len = 256;

  if (RegQueryValueEx(key, name, NULL, &type, (LPBYTE)&value, &buf_len) != ERROR_SUCCESS)
    return def;

  if (type != REG_SZ)
    return def;


  double ret = strtod(value, &stopstr);
  if (value == stopstr || errno == ERANGE)
    return def;

  return ret;
}

bool 
RegistryKey::get_text(LPCTSTR name, char *_value, int size)
{
  if (!key) return false;

  DWORD type;
  DWORD buf_len = size;

  if (RegQueryValueEx(key, name, NULL, &type, (LPBYTE)&_value, &buf_len) != ERROR_SUCCESS)
  {
    _value[0] = 0;
    return false;
  }

  if (type != REG_SZ)
  {
    _value[0] = 0;
    return false;
  }
  
  return true;
}

void
RegistryKey::set_bool(LPCTSTR name, bool _value)
{
  if (!key) return;

  DWORD value = _value;
  RegSetValueEx(key, name, NULL, REG_DWORD, (LPBYTE)&value, 4);
}

void
RegistryKey::set_int32(LPCTSTR name, int32_t _value)
{
  if (!key) return;

  DWORD value = _value;
  RegSetValueEx(key, name, NULL, REG_DWORD, (LPBYTE)&value, 4);
}

void
RegistryKey::set_double(LPCTSTR name, double _value)
{
  if (!key) return;

  char buf[256];
  sprintf(buf, "%f", _value);
  RegSetValueEx(key, name, NULL, REG_SZ, (LPBYTE)&buf, strlen(buf)+1);
}

void
RegistryKey::set_text(LPCTSTR name, const char *_value)
{
  if (!key) return;

  RegSetValueEx(key, name, NULL, REG_SZ, (LPBYTE)&_value, strlen(_value)+1);
}
