#include "ac3filter.h"
#include "dlg_main.h"
#include "dlg_mixer.h"

// setup data

const AMOVIESETUP_MEDIATYPE sudInPinTypes[] =
{
{&MEDIATYPE_Audio,     &MEDIASUBTYPE_NULL      },
{&MEDIATYPE_MPEG2_PES, &MEDIASUBTYPE_DOLBY_AC3 }
};

const AMOVIESETUP_MEDIATYPE sudOutPinTypes[] =
{
{&MEDIATYPE_Audio,     &MEDIASUBTYPE_PCM       }
};

const AMOVIESETUP_PIN psudPins[] =                 
{
  {
    L"Input",           // String pin name
    FALSE,              // Is it rendered
    FALSE,              // Is it an output
    FALSE,              // Allowed none
    FALSE,              // Allowed many
    &CLSID_NULL,        // Connects to filter
    L"Output",          // Connects to pin
    sizeof(sudInPinTypes) / sizeof(AMOVIESETUP_MEDIATYPE), // Number of types
    sudInPinTypes       // The pin details
  },     
  { 
    L"Output",          // String pin name
    FALSE,              // Is it rendered
    TRUE,               // Is it an output
    FALSE,              // Allowed none
    FALSE,              // Allowed many
    &CLSID_NULL,        // Connects to filter
    L"Input",           // Connects to pin
    sizeof(sudOutPinTypes) / sizeof(AMOVIESETUP_MEDIATYPE), // Number of types
    sudOutPinTypes      // The pin details
  }
};


const AMOVIESETUP_FILTER sudAC3Filter =
{
    &CLSID_AC3Filter,       // Filter CLSID
    L"AC3Filter",  // Filter name
    MERIT_NORMAL+0x04000000,// Its merit
    2,                      // Number of pins
    psudPins                // Pin details
};


CFactoryTemplate g_Templates[] = {
    { L"Main"
    , &CLSID_AC3Filter_main
    , CAC3Filter_main::CreateInstance },
    { L"Mixer"
    , &CLSID_AC3Filter_mixer
    , CAC3Filter_mixer::CreateInstance },
    { L"AC3Filter"
    , &CLSID_AC3Filter
    , AC3Filter::CreateInstance
    , NULL
    , &sudAC3Filter }
};
int g_cTemplates = sizeof(g_Templates) / sizeof(g_Templates[0]);


//
// Handle registration of this filter
//

STDAPI DllRegisterServer()
{
  return AMovieDllRegisterServer2( TRUE );
}

STDAPI DllUnregisterServer()
{
  return AMovieDllRegisterServer2( FALSE );
}
