#include <windows.h>
#include <streams.h>

int main(int argc, char *argv[])
{
  DWORD      buf[256];   // 1K buffer
  HKEY       reg, hive;
  DWORD      type, buf_len, merit;
  bool       silent;
  int        arg;

  if (argc < 4)
  {
    MessageBox(0, 
      "filter_merit is a program to change filter's merit.\n\n"
			"Usage:\n"
      "  filter_merit [/s] hive key merit\n\n"
      "where:\n"
      "  /s - if this key persist program will work in silent mode i.e. no error messages.\n"
			"  hive - registry hive:\n"
			"    0 - HKEY_CLASSES_ROOT    \n"
			"    1 - HKEY_CURRENT_USER    \n"
			"    2 - HKEY_LOCAL_MACHINE   \n"
			"    3 - HKEY_USERS           \n"
			"    4 - HKEY_PERFORMANCE_DATA\n"
			"    5 - HKEY_CURRENT_CONFIG  \n"
			"    6 - HKEY_DYN_DATA        \n"
			"  key - registry key where FilterData value of a filter placed\n"
			"  merit - new merit to set", "Usage", MB_OK | MB_ICONINFORMATION);
    return 0;
  }


  silent = false;
  arg = 1;
  if (argv[1][0] == '/')
  {
    arg = 2;
    if (argv[1][1] == 's')
      silent = true;
    else
    {
      MessageBox(0, "Invalid argument", "error", MB_OK | MB_ICONSTOP);
      return 0;
    }
  }


  merit = atoi(argv[arg+2]);
  switch(atoi(argv[arg]))
  {
  case 0: hive = HKEY_CLASSES_ROOT;     break;
  case 1: hive = HKEY_CURRENT_USER;     break;
  case 2: hive = HKEY_LOCAL_MACHINE;    break;
  case 3: hive = HKEY_USERS;            break;
  case 4: hive = HKEY_PERFORMANCE_DATA; break;
  case 5: hive = HKEY_CURRENT_CONFIG;   break;
  case 6: hive = HKEY_DYN_DATA;         break;
  default:
    if (!silent)
      MessageBox(0, "Cannot open registry key", "error", MB_OK | MB_ICONSTOP);
    return 0;
  }

  
  if (RegOpenKeyEx(hive, argv[arg+1], 0, KEY_READ | KEY_WRITE, &reg) != ERROR_SUCCESS)
  {
    if (!silent)
      MessageBox(0, "Cannot open registry key", "error", MB_OK | MB_ICONSTOP);
    return 0;
  }
  
  buf_len = 1024;
  if (RegQueryValueEx(reg, "FilterData", NULL, &type, (LPBYTE)&buf, &buf_len) != ERROR_SUCCESS)
  {
    if (!silent)
      MessageBox(0, "Cannot read registry", "error", MB_OK | MB_ICONSTOP);
    return 0;
  }

  if (type != REG_BINARY || buf_len < sizeof(REGFILTER2) || buf[0] != 2)
  {
    if (!silent)
      MessageBox(0, "Incorrect format", "error", MB_OK | MB_ICONSTOP);
    return 0;
  }

  buf[1] = merit;

  if (RegSetValueEx(reg, "FilterData", NULL, REG_BINARY, (LPBYTE)&buf, buf_len) != ERROR_SUCCESS)
  {
    if (!silent)
      MessageBox(0, "Cannot write registry", "error", MB_OK | MB_ICONSTOP);
    return 0;
  }

  RegCloseKey(reg);

  return 1;
}
