#ifndef DLG_MIXER_H
#define DLG_MIXER_H

#include <streams.h>
#include "vac3dec\defs.h"
#include "controls.h"
#include "guids.h"


class CAC3Filter_mixer : public CBasePropertyPage
{
public:
  static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
  IAC3Filter *filter;
  acmod_t     speakers;
  bool        visible;

  ComboBox    cmb_matrix;
  DoubleEdit  edt_matrix[6][6];
  DoubleEdit  edt_master;
  DoubleEdit  edt_gain;
  DoubleEdit  edt_voice;
  DoubleEdit  edt_sur;
  DoubleEdit  edt_lfe;

  CAC3Filter_mixer(LPUNKNOWN lpunk, HRESULT *phr);

  BOOL OnReceiveMessage(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

  HRESULT OnConnect(IUnknown *pUnknown);
  HRESULT OnDisconnect();
  HRESULT OnActivate();

  void init_controls();
  void set_dynamic_controls();
  void set_matrix_controls();
  void set_controls();

  void command(int control, int message);
};

#endif

