/*
  RegistryKey

  Load/save values of different types from/to registry

*/


#ifndef REGISTRY_H
#define REGISTRY_H

#include <windows.h>
#include "..\vac3dec\defs.h"

///////////////////////////////////////////////////////////////////////////////
// RegistryKey
///////////////////////////////////////////////////////////////////////////////

class RegistryKey
{
protected:
  HKEY key;

public:
  RegistryKey(LPCTSTR name);
  ~RegistryKey();

  bool create_key(LPCTSTR path, LPCTSTR name);
  bool is_ok() { return key != 0; }

  bool    get_bool(LPCTSTR name, bool def);
  int32_t get_int32(LPCTSTR name, int32_t def);
  double  get_double(LPCTSTR name, double def);
  bool    get_text(LPCTSTR name, char *value, int size);

  void set_bool(LPCTSTR name, bool value);
  void set_int32(LPCTSTR name, int32_t value);
  void set_double(LPCTSTR name, double value);
  void set_text(LPCTSTR name, const char *value);
};


#endif
