// ac3speakers.cpp : Defines the entry point for the application.
//

#include <windows.h>
#include "resource.h"
#include "registry.h"
#include "..\vac3dec\defs.h"


acmod_t speakers;
const int acmod2control[8] = 
{ IDC_RADIO_2_0, IDC_RADIO_1_0, IDC_RADIO_2_0, IDC_RADIO_3_0, IDC_RADIO_2_1, IDC_RADIO_3_1, IDC_RADIO_2_2, IDC_RADIO_3_2 };


LRESULT CALLBACK 
DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  switch (msg) 
  { 
  case WM_INITDIALOG:
    if (!IS_MODE_ERROR(speakers))
      SendDlgItemMessage(hwnd, acmod2control[MODE_ACMOD(speakers)], BM_SETCHECK, BST_CHECKED, 1);
    else
      SendDlgItemMessage(hwnd, IDC_RADIO_DEF, BM_SETCHECK, BST_CHECKED, 1);

    SendDlgItemMessage(hwnd, IDC_CHK_LFE, BM_SETCHECK, IS_MODE_LFE(speakers)? BST_CHECKED: BST_UNCHECKED, 1);
    SendDlgItemMessage(hwnd, IDC_CHK_SPDIF, BM_SETCHECK, IS_MODE_SPDIF(speakers)? BST_CHECKED: BST_UNCHECKED, 1);
    return TRUE;

  case WM_COMMAND:
    switch(LOWORD(wParam))
    {
      case IDOK:
        EndDialog(hwnd, IDOK);
        return TRUE;
      case IDCANCEL:
        EndDialog(hwnd, IDCANCEL);
        return TRUE;

      case IDC_RADIO_DEF: 
      {
        speakers = MODE_ERROR;
        for (int acmod = 0; acmod < 8; acmod++)
          SendDlgItemMessage(hwnd, acmod2control[acmod], BM_SETCHECK, BST_UNCHECKED, 1);
        SendDlgItemMessage(hwnd, IDC_RADIO_DEF, BM_SETCHECK, BST_CHECKED, 1);
        return TRUE;
      }


      case IDC_RADIO_1_0: speakers = MODE_1_0;   goto set_speakers;
      case IDC_RADIO_2_0: speakers = MODE_2_0;   goto set_speakers;
      case IDC_RADIO_3_0: speakers = MODE_3_0;   goto set_speakers;
      case IDC_RADIO_2_1: speakers = MODE_2_1;   goto set_speakers;
      case IDC_RADIO_3_1: speakers = MODE_3_1;   goto set_speakers;
      case IDC_RADIO_2_2: speakers = MODE_2_2;   goto set_speakers;
      case IDC_RADIO_3_2: speakers = MODE_3_2;   goto set_speakers;
      case IDC_CHK_LFE:   speakers = (SendDlgItemMessage(hwnd, IDC_CHK_LFE, BM_GETCHECK, 0, 0) == BST_CHECKED)? speakers | MODE_LFE: speakers & ~MODE_LFE; goto set_speakers;
      case IDC_CHK_SPDIF: speakers = (SendDlgItemMessage(hwnd, IDC_CHK_SPDIF, BM_GETCHECK, 0, 0) == BST_CHECKED)? speakers | MODE_SPDIF: speakers & ~MODE_SPDIF; goto set_speakers;
  set_speakers:
      {
        SendDlgItemMessage(hwnd, IDC_RADIO_DEF, BM_SETCHECK, BST_UNCHECKED, 1);
        for (int acmod = 0; acmod < 8; acmod++)
          SendDlgItemMessage(hwnd, acmod2control[acmod], BM_SETCHECK, BST_UNCHECKED, 1);

        SendDlgItemMessage(hwnd, acmod2control[MODE_ACMOD(speakers)], BM_SETCHECK, BST_CHECKED, 1);
        SendDlgItemMessage(hwnd, IDC_CHK_LFE, BM_SETCHECK, IS_MODE_LFE(speakers)? BST_CHECKED: BST_UNCHECKED, 1);
        SendDlgItemMessage(hwnd, IDC_CHK_SPDIF, BM_SETCHECK, IS_MODE_SPDIF(speakers)? BST_CHECKED: BST_UNCHECKED, 1);
        return TRUE;
      }
    }
  }

  return FALSE; 
}


int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
  RegistryKey reg("Software\\AC3Filter\\preset\\_default");
  if (!reg.is_ok())
  {
    // try to create key for new preset
    reg.create_key("Software", "AC3Filter");
    reg.create_key("Software\\AC3Filter", "preset");
    reg.create_key("Software\\AC3Filter\\preset", "_default");
  }

  if (!reg.is_ok())
  {
    MessageBox(0, "Cannot open registry key", "Error", MB_OK | MB_ICONSTOP);
    return 0;
  }

  speakers = reg.get_int32("acmod", MODE_ERROR);
  if (DialogBox(hInstance, MAKEINTRESOURCE(IDD_SPEAKERS), 0, (DLGPROC)DlgProc) == IDOK)
  {
    reg.set_int32("acmod", speakers);
    return 0;
  }
	return 1;
}



