/*
  DecoderControl

  Controls decoder via COM interface. 
  Registry interface (state load/save).
  CPU measurement.
  ISpecifyPropertyPages.

*/


#ifndef AC3DECODER_H
#define AC3DECODER_H

#include <streams.h>
#include "vac3dec\decoder.h"
#include "guids.h"


///////////////////////////////////////////////////////////////////////////////
// DecoderControl class
///////////////////////////////////////////////////////////////////////////////

class DecoderControl: 
  public Decoder, 
  public IAC3Filter,
  public ISpecifyPropertyPages
{
public:
  DecoderControl();
  ~DecoderControl();

public:

  // CPU usage measurement
  HANDLE   thread;
  __int64  thread_time;
  __int64  system_time_begin;
  __int64  thread_time_begin;

  void reset_time();
  virtual void reset();
  virtual void decode(uint8_t *buffer, uint32_t length);

  /////////////////////////////////////////////////////////
  // ISpecifyPropertyPages

  STDMETHODIMP GetPages(CAUUID *pPages);

  /////////////////////////////////////////////////////////
  // IAC3Filter

  // bit stream information
  STDMETHODIMP get_bsi      (BSI *bsi);
  STDMETHODIMP get_speakers (acmod_t *speakers);
//  STDMETHODIMP set_speakers (acmod_t  speakers);    // only filter itself knows now to set speakers
  STDMETHODIMP get_cpu_load (double *cpu_load);                                                                
  STDMETHODIMP get_stat     (int *frames, int *errors);                                                          

  // gain control
  STDMETHODIMP get_levels   (sample_t *source, sample_t *max_source, sample_t *speaker, sample_t *max_speaker); 
  STDMETHODIMP get_gain     (sample_t *master, sample_t *gain);                                                 
  STDMETHODIMP set_gain     (sample_t  master);                                                                 
  STDMETHODIMP get_dynrng   (bool *dynrng, sample_t *dynrng_level, sample_t *dynrng_power);                     
  STDMETHODIMP set_dynrng   (bool  dynrng, sample_t  dynrng_power);                                             

  // mixer
  STDMETHODIMP get_matrix   (mixer_matrix_t *matrix);                                                           
  STDMETHODIMP set_matrix   (mixer_matrix_t *matrix);                                                           
  STDMETHODIMP get_gains    (sample_t *slev, sample_t *clev, sample_t *lfelev);                                 
  STDMETHODIMP set_gains    (sample_t  slev, sample_t  clev, sample_t  lfelev);                                 
  STDMETHODIMP get_bsi_locks(bool *slev_lock, bool *clev_lock, bool *lfe_lock);                                 
  STDMETHODIMP set_bsi_locks(bool  slev_lock, bool  clev_lock, bool  lfe_lock);                                 
  STDMETHODIMP get_auto_matrix(bool *auto_matrix);                                                              
  STDMETHODIMP set_auto_matrix(bool  auto_matrix);                                                              
  STDMETHODIMP get_normalize_matrix(bool *normalize_matrix);
  STDMETHODIMP set_normalize_matrix(bool  normalize_matrix);
  STDMETHODIMP get_normalize(bool *normalize);                                                                  
  STDMETHODIMP set_normalize(bool  normalize);                                                                  
  STDMETHODIMP get_expand_stereo(bool *expand_stereo);
  STDMETHODIMP set_expand_stereo(bool  expand_stereo);
  STDMETHODIMP get_voice_control(bool *voice_control);
  STDMETHODIMP set_voice_control(bool  voice_control);

  // equalizer
  STDMETHODIMP get_equalize(sample_buffer_t *func);                                                                    
  STDMETHODIMP set_equalize(sample_buffer_t *func);                                                                    
  STDMETHODIMP get_spectrum(int ch, sample_buffer_t *func);                                                            

  // load/save parameters from registry
  STDMETHODIMP load_params(const char *preset = 0);
  STDMETHODIMP save_params(const char *preset = 0);
  STDMETHODIMP load_matrix(const char *preset = 0);
  STDMETHODIMP save_matrix(const char *preset = 0);
  STDMETHODIMP load_equalizer(const char *preset = 0);
  STDMETHODIMP save_equalizer(const char *preset = 0);
};


#endif