#include <streams.h>
#include <objbase.h>
#include <string>
#include <deque>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <math.h>


#include <windows.h>
#include <time.h>
#include <dsound.h>
#include <conio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <initguid.h>

#include "ac3decoder.h"

#include <ks.h>
#include <ksmedia.h>
#include <mmreg.h>




//const int channels = 2;


//----------------------------------------------------------------
// DS globals


IDirectSound       *ds;
IDirectSoundBuffer *ds_buf_prim;
IDirectSoundBuffer *ds_buf;
IDirectSoundNotify *ds_notify;
DSBPOSITIONNOTIFY   notifies[2];
HANDLE              events[2];


class CDSPlayer
{
protected:
  IDirectSound       *ds;
  IDirectSoundBuffer *ds_buf_prim;
  IDirectSoundBuffer *ds_buf;
  IDirectSoundNotify *ds_notify;
  DSBPOSITIONNOTIFY   notifies[2];
  HANDLE              events[2];
  WAVEFORMATEX       *format;
  DWORD              buffer_size;

public:
  CDSPlayer();
  ~CDSPlayer();

  void init(WAVEFORMATEX *_format, DWORD _buffer_size);
  virtual void fill_buffer(void *_buffer, DWORD _buffer_size) = 0;
  void play();
};

CDSPlayer::CDSPlayer()
{
  if FAILED(DirectSoundCreate(0, &ds, 0))
    throw std::string("Cannot create direct sound object");

  HWND hWnd = GetForegroundWindow();
  if (hWnd == NULL)
    hWnd = GetDesktopWindow();

  if FAILED(ds->SetCooperativeLevel(hWnd, DSSCL_PRIORITY))
    throw std::string("Cannot set coop level");

  DSBUFFERDESC dsbdesc;
  ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
  dsbdesc.dwSize  = sizeof(DSBUFFERDESC);
  dsbdesc.dwFlags = DSBCAPS_PRIMARYBUFFER;
 
  if FAILED(ds->CreateSoundBuffer(&dsbdesc, &ds_buf_prim, 0))
    throw std::string("Cannot create primary sound buffer");

  ds_buf = 0;
  format = 0;
}


void 
CDSPlayer::init(WAVEFORMATEX *_format, DWORD _buffer_size)
{
  if (format) delete format;

  format = (WAVEFORMATEX *) new BYTE[sizeof(WAVEFORMATEX) + _format->cbSize];
  memcpy(format, _format, sizeof(WAVEFORMATEX) + _format->cbSize); 
  buffer_size = _buffer_size;

  if FAILED(ds_buf_prim->SetFormat(format))
    throw std::string("Cannot set wave format");

/////////////

  DSBUFFERDESC dsbdesc;
  ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
  dsbdesc.dwSize        = sizeof(DSBUFFERDESC);
  dsbdesc.dwFlags       = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS | DSBCAPS_CTRLPOSITIONNOTIFY;
  dsbdesc.dwBufferBytes = buffer_size * 2;
  dsbdesc.lpwfxFormat   = format;

  if (ds_buf) ds_buf->Release();

  if FAILED(ds->CreateSoundBuffer(&dsbdesc, &ds_buf, 0))
    throw std::string("Cannot create sound buffer");

  for (int i = 0; i < 2; i++)
  {
    if (!(events[i] = CreateEvent(NULL, false, false, NULL)))
      throw std::string("Cannot create event");
 
    notifies[i].dwOffset = i * buffer_size;
    notifies[i].hEventNotify = events[i];
  }
 
  if FAILED(ds_buf->QueryInterface(IID_IDirectSoundNotify, (void **)&ds_notify))
    throw std::string("Cannot get notify interface");

  if FAILED(ds_notify->SetNotificationPositions(2, notifies))
  {
    ds_notify->Release();
    throw std::string("Cannot set notification positions");
  }
}

CDSPlayer::~CDSPlayer()
{
  if (ds)  ds->Release();
  CloseHandle(events[0]);
  CloseHandle(events[1]);
  if (format) delete format;
}

void
CDSPlayer::play()
{
  void *data;
  DWORD data_bytes;

  if (!ds_buf) return;
  if FAILED(ds_buf->Lock(0, 2 * buffer_size, &data, &data_bytes, 0, 0, 0))
    throw std::string("Cannot lock sound buffer");

  ZeroMemory(data, data_bytes);

  if FAILED(ds_buf->Unlock(data, data_bytes, 0, 0))
    throw std::string("Cannot unlock sound buffer");

  ds_buf->SetCurrentPosition(0);

  if FAILED(ds_buf->Play(0, 0, DSBPLAY_LOOPING))
    throw std::string("Cannot play sound buffer");

  DWORD event = 0;

  while(1)
  {
    event = WaitForMultipleObjects(2, events, false, INFINITE);
    event -= WAIT_OBJECT_0;

    if FAILED(ds_buf->Lock((1-event) * buffer_size, buffer_size, (void **)&data, &data_bytes, 0, 0, 0))
      throw std::string("Cannot lock sound buffer");

    fill_buffer(data, data_bytes);

    if FAILED(ds_buf->Unlock(data, data_bytes, 0, 0))
      throw std::string("Cannot unlock sound buffer");
 }
}

///////////////////////////////////////////


const int blocks_per_buffer = 100;
class CA52Player : public CDSPlayer, public DecoderControl
{
protected:
  class CBuffer
  {
  public:
    WORD buffer[256 * 6 * blocks_per_buffer]; 
  };

  CBuffer *current_buffer;
  int current_block;
  std::deque<CBuffer*> buffers;
  FILE *f;
  int nchannels;

public:
  CA52Player(const char *_file, int _nchannels);
  ~CA52Player();

  void fill_buffer(void *_buffer, DWORD _length);
  void block();
};


CA52Player::CA52Player(const char *_file, int _nchannels)
{
  const int ds_channels[7] = 
  {
    SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT,  // default
    SPEAKER_FRONT_CENTER,
    SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT,
    SPEAKER_FRONT_LEFT | SPEAKER_FRONT_CENTER | SPEAKER_FRONT_RIGHT,
    SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT  | SPEAKER_BACK_LEFT   | SPEAKER_BACK_RIGHT,
    SPEAKER_FRONT_LEFT | SPEAKER_FRONT_CENTER | SPEAKER_FRONT_RIGHT | SPEAKER_BACK_LEFT | SPEAKER_BACK_RIGHT,
    SPEAKER_FRONT_LEFT | SPEAKER_FRONT_CENTER | SPEAKER_FRONT_RIGHT | SPEAKER_BACK_LEFT | SPEAKER_BACK_RIGHT | SPEAKER_LOW_FREQUENCY,
  };
  const int ac3_mode[7] = 
  {
    MODE_STEREO,     // default
    MODE_MONO,
    MODE_STEREO,
    MODE_3_0,
    MODE_2_2,
    MODE_3_2,
    MODE_3_2 | MODE_LFE
  };
  const channel_order_t ac3_channels[7] = 
  {
    { CH_L, CH_R, 0, 0, 0, 0 },
    { CH_C, 0, 0, 0, 0, 0 },
    { CH_L, CH_R, 0, 0, 0, 0 },
    { CH_L, CH_R, CH_C, 0, 0, 0 },
    { CH_L, CH_R, CH_SL, CH_SR, 0, 0 },
    { CH_L, CH_R, CH_C, CH_SL, CH_SR, 0 },
    { CH_L, CH_R, CH_C, CH_LFE, CH_SL, CH_SR }
  };

  nchannels = _nchannels;
  if (nchannels > 6) nchannels = 0;
  if (nchannels < 0) nchannels = 0;

  WAVEFORMATEXTENSIBLE wfe;
  ZeroMemory(&wfe, sizeof(WAVEFORMATEXTENSIBLE));
  wfe.Format.wFormatTag = WAVE_FORMAT_EXTENSIBLE;
  wfe.Format.nChannels = nchannels;
  wfe.Format.nSamplesPerSec = 48000;
  wfe.Format.wBitsPerSample = 16;
  wfe.Format.nBlockAlign = 2*nchannels;
  wfe.Format.nAvgBytesPerSec = 48000 * wfe.Format.nBlockAlign;
  wfe.Format.cbSize = 22;
  wfe.Samples.wValidBitsPerSample = 16;
  wfe.SubFormat = KSDATAFORMAT_SUBTYPE_PCM;
  wfe.dwChannelMask = ds_channels[nchannels];

  current_buffer = new CBuffer();
  current_block = 0;
  f = fopen(_file, "rb");
  if (!f) throw std::string("Cannot open file");

  CDSPlayer::init((WAVEFORMATEX *)&wfe, blocks_per_buffer * 256 * nchannels * 2);
  reset();
  mixer.level = 32000.0;
  mixer.set_output_mode(ac3_mode[nchannels], ac3_channels[nchannels]);
}

CA52Player::~CA52Player()
{
  if (current_buffer) delete current_buffer;
  while (buffers.size())
  {
    delete buffers.back();
    buffers.pop_back();
  }
  if (f) fclose(f);
}

void
CA52Player::block()
{
  if (current_block >= blocks_per_buffer)
  {
    current_block = 0;
    buffers.push_front(current_buffer);
    current_buffer = new CBuffer();
  }

  ZeroMemory(current_buffer, 256*2*nchannels);
  for (int i = 0; i < 256; i++)
    for (int j = 0; j < nchannels; j++)
      current_buffer->buffer[i*nchannels+j + current_block * 256 * nchannels] = samples[j][i] * 32000;
//      samples[i+(channel_basis[nchannels-1][(channels&A52_CHANNEL_MASK)-1][j]+(channels&A52_LFE >> 4))*256];
  current_block++;

  printf("frames played: %i, errors: %i\r", frames, errors);
}

void
CA52Player::fill_buffer(void *_buffer, DWORD length)
{
  while (!buffers.size())
  {
    char file_buffer[5000];
    fread(file_buffer, 5000, 1, f);
    decode((BYTE*)file_buffer, 5000);
  }
  CBuffer *buffer = buffers.back();
  buffers.pop_back();
  memcpy(_buffer, buffer->buffer, length);
  delete buffer;
}

///////////////////////////////////////////


class CA52Decoder : public DecoderControl
{
protected:
  FILE *f;
  int nchannels;

public:
  CA52Decoder(const char *_file, int _nchannels);
  ~CA52Decoder();

  void block();
  void run();
};


CA52Decoder::CA52Decoder(const char *_file, int _nchannels)
{
  const int ac3_mode[7] = 
  {
    MODE_STEREO,     // default
    MODE_MONO,
    MODE_STEREO,
    MODE_3_0,
    MODE_2_2,
    MODE_3_2,
    MODE_3_2 | MODE_LFE
  };
  const channel_order_t ac3_channels[7] = 
  {
    { CH_L, CH_R, 0, 0, 0, 0 },
    { CH_C, 0, 0, 0, 0, 0 },
    { CH_L, CH_R, 0, 0, 0, 0 },
    { CH_L, CH_R, CH_C, 0, 0, 0 },
    { CH_L, CH_R, CH_SL, CH_SR, 0, 0 },
    { CH_L, CH_R, CH_C, CH_SL, CH_SR, 0 },
    { CH_L, CH_R, CH_C, CH_LFE, CH_SL, CH_SR }
  };


  
  nchannels = _nchannels;
  if (nchannels > 6) nchannels = 0;
  if (nchannels < 0) nchannels = 0;

  f = fopen(_file, "rb");
  if (!f) throw std::string("Cannot open file");

  reset();
//  mixer.level = 32000.0;
  mixer.set_output_mode(ac3_mode[nchannels], ac3_channels[nchannels]);
}

CA52Decoder::~CA52Decoder()
{
  if (f) fclose(f);
}

void
CA52Decoder::block()
{
  printf("frames played: %i, errors: %i\r", frames, errors);
}

void
CA52Decoder::run()
{
  unsigned char buf[64000];
  while (fread(buf, 1, 64000, f))
    decode(buf, 64000);
}
/*
class CDSFreqGen : public CDSPlayer
{
public:
  CDSFreqGen(WAVEFORMATEX *_format): CDSPlayer(_format), phase(0) {};
protected:
  double phase;


  void fill_buffer(void *_buffer, DWORD _buffer_size)
  {
    for (int i = 0; i < _buffer_size / 4; i++)
    {
      ((WORD *)_buffer)[i*2] =   sin(phase)*32000;
      ((WORD *)_buffer)[i*2+1] = sin(phase)*32000;
      phase += 0.01;
    }
  }
};
*/

void main()
{
  try
  {
    CA52Player a52("f:\\films\\ac3test\\ac3test.ac3", 2);
    a52.play();

//    CA52Decoder a52("c:\\test.ac3", 6);
//    a52.run();


  }
  catch(std::string s)
  {
    printf("error: %s", s.c_str());
    getch();
  }
  catch(...)
  {
    printf("some strange happen");
    getch();
  }

}
