#ifndef PARSER_H
#define PARSER_H


#include "defs.h"
#include "bitstream.h"



typedef int16_t mant_t;
typedef int8_t  exp_t;



struct chinfo_t
{
  int      strtmant;   // channel starting mantissa
  int      endmant;    // channel end mantissa

  int      fastleak;   // fast leak initialisation
  int      slowleak;   // slow leak initialisation
  int      fsnroffst;  // fine snr offset
  int      fgain;      // fast gain

  uint8_t  deltbae;    // delta bit allocation exists
  int8_t   deltba[50]; // per-band delta bit allocation

  int8_t   bap[256];   // derived channel bit allocation
  exp_t    exp[256];   // channel exponents
//  sample_t coef[256];  // channel coefs
};


class Parser
{
protected:
  class AC3Bitstream : public Bitstream
  {
  private:
    int16_t q3[2];
    int16_t q5[2];
    int16_t q11;
    int     nq3;
    int     nq5;
    int     nq11;

  public:
    AC3Bitstream(): nq3(-1), nq5(-1), nq11(-1) {};
    inline void    reset_mantissas() { nq3 = -1; nq5 = -1; nq11 = -1; }
    inline int16_t get_mantissa(int8_t bap);
  };

public:
  // bsi
  uint8_t  fscod;       // frame size code
  uint8_t  halfrate;    // halfrate flag
  uint8_t  bsid;        // bit stream identification
  acmod_t  acmod;       // audio coding mode (modif)
  uint8_t  lfeon;       // LFE if on

  uint8_t  dialnorm;    // dialog normalization 
  uint8_t  compre;      // compression gain word exists
  uint8_t  compr;       // compression gain word
  uint8_t  langcode;    // language code exists
  uint8_t  langcod;     // language code
  uint8_t  audprodie;   // audio production information exists
  uint8_t  mixlevel;    // mixing level (SPL)
  uint8_t  roomtyp;     // room type
                        
  uint8_t  dialnorm2;   // dialog normalization 
  uint8_t  compr2e;     // compression gain word exists
  uint8_t  compr2;      // compression gain word
  uint8_t  langcod2e;   // language code exists
  uint8_t  langcod2;    // language code
  uint8_t  audprodi2e;  // audio production information exists
  uint8_t  mixlevel2;   // mixing level (SPL)
  uint8_t  roomtyp2;    // room type

  uint8_t  copyrightb;  // copyright bit
  uint8_t  origbs;      // original bitstream

  struct {
    int hours;
    int mins;
    int secs;
    int frames;
    int fracs;
  } timecode;           // timecode

  int      sample_rate; // sample_rate
  int      bitrate;     // bitrate

  sample_t clev;        // center mix level
  sample_t slev;        // surround mix level
  bool     dynrnge;     // dynamic range gain word exists
  sample_t dynrng;      // dynamic range gain word
  bool     dynrng2e;    // dynamic range gain word exists
  sample_t dynrng2;     // dynamic range gain word


  // block private (reusable information only)
  int      chincpl;     // channels in coupling
  int      ncplbnd;     // number of coupling bands
  int      phsflginu;   // phase flags in use
  uint8_t  rematflg;    // stereo rematrixing
  int      cplbnd[18];  // coupling band end bin numbers
  sample_t cplco[5][18];// coupling cordinates
  uint8_t  dithflag[5]; // dither flag

  chinfo_t cplinfo;     // coupling channel info
  chinfo_t chinfo[5];   // fbw channels info
  chinfo_t lfeinfo;     // lfe channel info

  uint8_t  csnroffst;   // coarse SNR offset
  uint16_t bai;         // bit allocation information

  // block public
//  sample_buffer_t samples; // decoded sample coefs
  uint8_t  blksw[5];    // block switch
  uint8_t  gainrng[5];  // channel gain range code


  AC3Bitstream bitstream;

  Parser() { reset(); }

  void reset    ();
  void get_bsi(BSI &bsi);

  int  syncinfo (uint8_t *buf);
  int  frame(uint8_t *buf);
  int  parse_block(sample_buffer_t &samples);

  int  parse_exponents (int expstr, int ngrps, exp_t exponent, exp_t *dest);
  int  parse_deltba(int8_t *deltba);
  bool is_zero_snr_offsets();
  void bit_allocate (chinfo_t &chinfo);
};



///////////////////////////////////////////////////////////////////////////////

extern const mant_t q3_tbl[3];
extern const mant_t q5_tbl[5];
extern const mant_t q7_tbl[7];
extern const mant_t q11_tbl[11];
extern const mant_t q15_tbl[15];

inline int16_t
Parser::AC3Bitstream::get_mantissa(int8_t bap)
{
  if (bap > 4)
    return get_signed(bap) << (16 - bap); //MANTISSA_JUSTIFY(get_signed(bap), bap);

  switch (bap)
  {
    case -1:
      if (nq3 >= 0) 
        return q3[nq3--];
      else 
      {
        int code = get(5);
        nq3 = 1;
        q3[0] = q3_tbl[(code%9)%3];
        q3[1] = q3_tbl[(code%9)/3];
        return q3_tbl[code/9];
      }

    case -2:
      if (nq5 >= 0) 
        return q5[nq5--];
      else 
      {
        int code = get(7);
        nq5 = 1;
        q5[0] = q5_tbl[(code%25)%5];
        q5[1] = q5_tbl[(code%25)/5];
        return q5_tbl[code/25];
      }

    case 3:          
      return q7_tbl[get(3)];

    case -3:
      if (nq11 >= 0)
      {
        nq11--;
        return q11;
      }
      else
      {
        int code = get(7);
        nq11 = 0;
        q11 = q11_tbl[code%11];
        return q11_tbl[code/11];
      }

    case 4:
      return q15_tbl[get(4)];

    case 0:
      return 0;
  }
  // we'll never be here
  return get_signed(bap) << (16 - bap); //MANTISSA_JUSTIFY(get_signed(bap), bap);
}



#endif
