#ifndef VAC3DEC_DEFS_H
#define VAC3DEC_DEFS_H


// base word types
//
typedef signed char     int8_t;
typedef signed short    int16_t;
typedef signed int      int32_t;
#ifdef ARCH_X86
  typedef signed long long int64_t;
#endif

typedef unsigned char   uint8_t;
typedef unsigned short  uint16_t;
typedef unsigned int    uint32_t;
#ifdef ARCH_X86
  typedef unsigned long long uint64_t;
#endif


#ifndef VAC3DEC_DOUBLE
typedef float sample_t;
#else
typedef double sample_t;
#endif

#define NCHANNELS    6
#define NSAMPLES     256
typedef sample_t sample_buffer_t[NCHANNELS][NSAMPLES];
typedef sample_t mixer_matrix_t[NCHANNELS][NCHANNELS];

// level multipliers
#define LEVEL_PLUS6DB 2.0
#define LEVEL_PLUS3DB 1.4142135623730951
#define LEVEL_3DB     0.7071067811865476
#define LEVEL_45DB    0.5946035575013605
#define LEVEL_6DB     0.5  


// audio coding mode type, used to specify audio format
// one of MODE_XXXX constants and may be flagged with MODE_LFE and/or MODE_DOLBY
typedef uint8_t acmod_t;

// channels definition, used to define channel configuration
// composed of number of CH_MASK_X masks
typedef uint8_t channels_t;

// channels order definition
// array of channel names CH_XXX
typedef uint8_t channel_order_t[NCHANNELS];


// coding modes
// equivalent to A52/A standart modes, except flags MODE_LFE and MODE_DOLBY
#define MODE_DUAL    0
#define MODE_1_0     1
#define MODE_2_0     2
#define MODE_3_0     3
#define MODE_2_1     4
#define MODE_3_1     5
#define MODE_2_2     6
#define MODE_3_2     7

#define MODE_LFE     8  // can be combined with any mode
#define MODE_DOLBY   16 // can be combined only with 2/0 mode, ignored in other modes
#define MODE_ERROR   32 // not a standart mode

#define MODE_MONO    1
#define MODE_STEREO  2
#define MODE_QUADRO  6
#define MODE_5_1     (MODE_3_2 | MODE_LFE)

// channel numbers
// used as index in arrays
#define CH_L         0  // Left channel
#define CH_C         1  // Center channel
#define CH_R         2  // Right channel
#define CH_SL        3  // Surround left channel
#define CH_SR        4  // Surround right channel
#define CH_LFE       5  // LFE channel

#define CH_M         1  // Mono channel = center channel
#define CH_CH1       0  // Channel 1 in Dual mono mode
#define CH_CH2       1  // Channel 2 in Dual mono mode
#define CH_S         3  // Surround channel for x/1 modes


// channel masks
// used as channel presence flag
#define CH_MASK_L    1
#define CH_MASK_C    2
#define CH_MASK_R    4
#define CH_MASK_SL   8
#define CH_MASK_SR   16
#define CH_MASK_LFE  32
#define CH_MASK_LAST 32

#define CH_MASK_M    4
#define CH_MASK_C1   0
#define CH_MASK_C2   2
#define CH_MASK_S    8
#define CH_MASK(ch)  (1 << (ch))




const channels_t _mode_ch[8] =
{
  CH_MASK_C1 | CH_MASK_C2,
  CH_MASK_M,
  CH_MASK_L  | CH_MASK_R,
  CH_MASK_L  | CH_MASK_C | CH_MASK_R,
  CH_MASK_L  | CH_MASK_R | CH_MASK_S,
  CH_MASK_L  | CH_MASK_C | CH_MASK_R  | CH_MASK_S,
  CH_MASK_L  | CH_MASK_R | CH_MASK_SL | CH_MASK_SR,
  CH_MASK_L  | CH_MASK_C | CH_MASK_R  | CH_MASK_SL | CH_MASK_SR,
};

const int _mode_nfchans[8] = { 2, 1, 2, 3, 3, 4, 4, 5 };
const int _mode_nfront[8]  = { 2, 1, 2, 3, 2, 3, 2, 3 };
const int _mode_nrear[8]   = { 0, 0, 0, 0, 1, 1, 2, 2 };

// mode macros
#define IS_MODE_SURROUND(mode) ((mode) & 4)
#define IS_MODE_DOLBY(mode)    ((mode) & MODE_DOLBY)
#define IS_MODE_LFE(mode)      ((mode) & MODE_LFE)
#define IS_MODE_ERROR(mode)    ((mode) & ~31)
#define MODE_ACMOD(mode)       ((mode) & 7)
#define MODE_CH(mode)          (_mode_ch[(mode)&7] | (IS_MODE_LFE((mode))? CH_MASK_LFE: 0))
#define MODE_NFCHANS(mode)     (_mode_nfchans[(mode)&7])
#define MODE_NFRONT(mode)      (_mode_nfront[(mode)&7])
#define MODE_NREAR(mode)       (_mode_nrear[(mode)&7])
#define MODE_NCHANS(mode)      (_mode_nfchans[(mode)&7] + (IS_MODE_LFE((mode))? 1: 0))
//#define NFCHAN2CH(nfchan,mode) ((nfchan)? (nfchan)+(~(mode)&1): 0)

class BSI
{
public:
  /////////////////////////////////////////////////////////
  // frame-wide info
  /////////////////////////////////////////////////////////

  acmod_t   acmod;
  int       bsid;
  int       frame_size;
  int       bitrate;
  int       sample_rate;

  sample_t  clev;        // center mix level
  sample_t  slev;        // surround mix level

  bool      compre;      // compression gain word exists
  sample_t  compr;       // compression gain word
  bool      compr2e;     // compression gain word 2 exists
  sample_t  compr2;      // compression gain word 2

  int       dialnorm;    // dialog normalization 
  int       dialnorm2;   // dialog normalization 2

  bool      langcode;    // language code exists
  int       langcod;     // language code
  bool      langcod2e;   // language code 2 exists
  int       langcod2;    // language code 2

  bool      audprodie;   // audio production information exists
  int       mixlevel;    // mixing level (SPL)
  int       roomtyp;     // room type
                        
  bool      audprodi2e;  // audio production information 2 exists
  int       mixlevel2;   // mixing level (SPL) 2
  int       roomtyp2;    // room type 2

  bool      copyrightb;  // copyright bit
  bool      origbs;      // original bitstream

  struct {
    int hours;
    int mins;
    int secs;
    int frames;
    int fracs;
  } timecode;           // timecode

  /////////////////////////////////////////////////////////
  // block-wide info
  /////////////////////////////////////////////////////////

  bool      dynrnge;     // dynamic range gain word exists
  sample_t  dynrng;      // dynamic range gain word
  bool      dynrng2e;    // dynamic range gain word 2 exists
  sample_t  dynrng2;     // dynamic range gain word 2

  int       chincpl;     // channels in coupling
  int       cplbegf;     // coupling start frequency
  int       cplendf;     // coupling end frequency
  int       chendf[5];   // channel end frequency
};



#endif
