#include "rot.h"

ROTEntry::ROTEntry(IFilterGraph *graph)
{
  IMoniker *moniker;
  IRunningObjectTable *rot;

  ok = false;
  if FAILED(GetRunningObjectTable(0, &rot)) return;
  
  WCHAR str[256];
  wsprintfW(str, L"FilterGraph %08x pid %08x", (DWORD_PTR)graph, GetCurrentProcessId());
  if SUCCEEDED(CreateItemMoniker(L"!", str, &moniker)) 
  {
    if SUCCEEDED(rot->Register(0, (IUnknown *)graph, moniker, &register_id))
      ok = true;
    moniker->Release();
  }
  rot->Release();
}

ROTEntry::~ROTEntry()
{
  IRunningObjectTable *rot;
  if (ok && SUCCEEDED(GetRunningObjectTable(0, &rot))) 
  {
    rot->Revoke(register_id);
    rot->Release();
  }
}
