#ifndef AC3FILTER_GUIDS_H
#define AC3FILTER_GUIDS_H

#include <objbase.h>
#include "vac3dec\defs.h"

// {E4539501-C609-46ea-AD2A-0E9700245683}
DEFINE_GUID(IID_IAC3Filter, 
0xe4539501, 0xc609, 0x46ea, 0xad, 0x2a, 0xe, 0x97, 0x0, 0x24, 0x56, 0x83);

// {D0C148F0-4B08-4b70-8FF4-A8D3DB15DFF8}
DEFINE_GUID(IID_IAC3Mixer, 
0xd0c148f0, 0x4b08, 0x4b70, 0x8f, 0xf4, 0xa8, 0xd3, 0xdb, 0x15, 0xdf, 0xf8);

// {A753A1EC-973E-4718-AF8E-A3F554D45C44}
DEFINE_GUID(CLSID_AC3Filter, 
0xa753a1ec, 0x973e, 0x4718, 0xaf, 0x8e, 0xa3, 0xf5, 0x54, 0xd4, 0x5c, 0x44);

// {FBA5FB05-58C3-45cb-8B0D-C2313EA048CF}
DEFINE_GUID(CLSID_AC3Filter_main, 
0xfba5fb05, 0x58c3, 0x45cb, 0x8b, 0xd, 0xc2, 0x31, 0x3e, 0xa0, 0x48, 0xcf);

// {F0B801B1-A239-473b-B6B4-6AE3DB3ABBD3}
DEFINE_GUID(CLSID_AC3Filter_mixer, 
0xf0b801b1, 0xa239, 0x473b, 0xb6, 0xb4, 0x6a, 0xe3, 0xdb, 0x3a, 0xbb, 0xd3);

DECLARE_INTERFACE_(IAC3Filter, IUnknown)
{
  // bit stream information
  STDMETHOD(get_bsi)      (BSI *bsi) = 0;                                                                          
  STDMETHOD(get_speakers) (acmod_t *speakers) = 0;                                                                 
  STDMETHOD(set_speakers) (acmod_t  speakers) = 0;                                                                 
  STDMETHOD(get_cpu_load) (double *cpu_load) = 0;                                                                
  STDMETHOD(get_stat)     (int *frames, int *errors) = 0;                                                          

  // gain control
  STDMETHOD(get_levels)   (sample_t *source, sample_t *max_source, sample_t *speaker, sample_t *max_speaker) = 0;  // mixer
  STDMETHOD(get_gain)     (sample_t *master, sample_t *gain) = 0;                                                  // mixer
  STDMETHOD(set_gain)     (sample_t  master) = 0;                                                                  // mixer
  STDMETHOD(get_dynrng)   (bool *dynrng, sample_t *dynrng_level, sample_t *dynrng_power) = 0;                      // decoder
  STDMETHOD(set_dynrng)   (bool  dynrng, sample_t  dynrng_power) = 0;                                              // decoder

  // mixer
  STDMETHOD(get_matrix)   (mixer_matrix_t *matrix) = 0;                                                            // mixer
  STDMETHOD(set_matrix)   (mixer_matrix_t *matrix) = 0;                                                            // mixer
  STDMETHOD(get_gains)    (sample_t *slev, sample_t *clev, sample_t *lfelev) = 0;                                  // mixer
  STDMETHOD(set_gains)    (sample_t  slev, sample_t  clev, sample_t  lfelev) = 0;                                  // mixer
  STDMETHOD(get_bsi_locks)(bool *slev_lock, bool *clev_lock, bool *lfe_lock) = 0;                                  // decoder
  STDMETHOD(set_bsi_locks)(bool  slev_lock, bool  clev_lock, bool  lfe_lock) = 0;                                  // decoder
  STDMETHOD(get_auto_matrix)(bool *auto_matrix) = 0;                                                               // decoder
  STDMETHOD(set_auto_matrix)(bool  auto_matrix) = 0;                                                               // decoder
  STDMETHOD(get_normalize_matrix)(bool *normalize_matrix) = 0;                                                     // decoder
  STDMETHOD(set_normalize_matrix)(bool  normalize_matrix) = 0;                                                     // decoder
  STDMETHOD(get_normalize)(bool *normalize) = 0;                                                                   // mixer
  STDMETHOD(set_normalize)(bool  normalize) = 0;                                                                   // mixer
  STDMETHOD(get_expand_stereo)(bool *expand_stereo) = 0;                                                           // mixer
  STDMETHOD(set_expand_stereo)(bool  expand_stereo) = 0;                                                           // mixer
  STDMETHOD(get_voice_control)(bool *voice_control) = 0;                                                           // mixer
  STDMETHOD(set_voice_control)(bool  voice_control) = 0;                                                           // mixer

  // equalizer
  STDMETHOD(get_equalize)(sample_buffer_t *func) = 0;                                                              // decoder
  STDMETHOD(set_equalize)(sample_buffer_t *func) = 0;                                                              // decoder
  STDMETHOD(get_spectrum)(int ch, sample_buffer_t *func) = 0;                                                      // decoder

  // load/save parameters from registry
  STDMETHOD(load_params)(const char *preset = 0) = 0;
  STDMETHOD(save_params)(const char *preset = 0) = 0;
  STDMETHOD(load_matrix)(const char *preset = 0) = 0;
  STDMETHOD(save_matrix)(const char *preset = 0) = 0;
  STDMETHOD(load_equalizer)(const char *preset = 0) = 0;
  STDMETHOD(save_equalizer)(const char *preset = 0) = 0;

};

DECLARE_INTERFACE_(IID_IAC3Mixer, IUnknown)
{
};




#endif
