#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "controls.h"

void LastErrorMessage()
{
  LPVOID lpMsgBuf;
  FormatMessage( 
    FORMAT_MESSAGE_ALLOCATE_BUFFER | 
    FORMAT_MESSAGE_FROM_SYSTEM | 
    FORMAT_MESSAGE_IGNORE_INSERTS,
    NULL,
    GetLastError(),
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
      (LPTSTR) &lpMsgBuf,
      0,
      NULL 
  );
  // Process any inserts in lpMsgBuf.
  // ...
  // Display the string.
  MessageBox( NULL, (LPCTSTR)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
  // Free the buffer.
  LocalFree( lpMsgBuf );
}


ComboBox::~ComboBox()
{
  unlink();
}

void
ComboBox::link(HWND _dlg, int _item)
{
  if (hwnd) unlink();

  dlg = _dlg;
  item = _item;
  hwnd = GetDlgItem(_dlg, _item);
  if (hwnd)
  {
    memset(&info, 0, sizeof(info));
    info.cbSize = sizeof(info);
    if (!GetComboBoxInfo(hwnd, &info))
    {
      LastErrorMessage();
      hwnd = 0;
      return;
    }
    wndproc = (WNDPROC) SetWindowLong(info.hwndItem, GWL_WNDPROC, (DWORD) SubClassProc);
    SetWindowLong(info.hwndItem, GWL_USERDATA, (DWORD) this);
  }
}

void 
ComboBox::unlink()
{
  if (hwnd)
  {
    SetWindowLong(hwnd, GWL_WNDPROC, (DWORD)wndproc);
    SetWindowLong(hwnd, GWL_USERDATA, 0);
  }

  dlg = 0;
  item = 0;
  hwnd = 0;
}

LRESULT CALLBACK 
ComboBox::SubClassProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  ComboBox *iam = (ComboBox *)GetWindowLong(hwnd, GWL_USERDATA);

  switch (msg) 
  { 
    case WM_GETDLGCODE:
      return CallWindowProc(iam->wndproc, hwnd, msg, wParam, lParam) | DLGC_WANTALLKEYS;

    case WM_KEYDOWN: 
      switch (wParam) 
      { 
        case VK_RETURN: 
          SendMessage(iam->dlg, WM_COMMAND, MAKEWPARAM(iam->item, CB_ENTER), 0); 
          return 0; 
      } 
      break; 
                            
    case WM_KEYUP: 
    case WM_CHAR: 
      switch (wParam) 
      { 
        case VK_RETURN: 
          return 0; 
      } 
  } 
        
        // Call the original window procedure for default processing. 
        return CallWindowProc(iam->wndproc, hwnd, msg, wParam, lParam); 
}

///////////////////////////////////////////////////////////////////////////////

Edit::~Edit()
{
  unlink();
}

void
Edit::link(HWND _dlg, int _item)
{
  if (hwnd) unlink();

  dlg = _dlg;
  item = _item;
  hwnd = GetDlgItem(_dlg, _item);
  if (hwnd)
  {
    wndproc = (WNDPROC) SetWindowLong(hwnd, GWL_WNDPROC, (DWORD) SubClassProc);
    SetWindowLong(hwnd, GWL_USERDATA, (DWORD)(Edit *)this);
  }
}

void 
Edit::unlink()
{
  if (hwnd)
  {
    SetWindowLong(hwnd, GWL_WNDPROC, (DWORD)wndproc);
    SetWindowLong(hwnd, GWL_USERDATA, 0);
  }

  dlg = 0;
  item = 0;
  hwnd = 0;
}

void
Edit::enable(bool enabled)
{
  EnableWindow(hwnd, enabled);
}

LRESULT CALLBACK 
Edit::SubClassProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  Edit *iam = (Edit *)GetWindowLong(hwnd, GWL_USERDATA);

  switch (msg) 
  { 
    case WM_GETDLGCODE:
      return CallWindowProc(iam->wndproc, hwnd, msg, wParam, lParam) | DLGC_WANTALLKEYS;

    case WM_KILLFOCUS:
      if (iam->editing)
      {
        if (iam->set_value())
        {
          iam->print_value();
          SendMessage(iam->dlg, WM_COMMAND, MAKEWPARAM(iam->item, CB_ENTER), 0); 
        }
        else
        {
          iam->restore_value();
          iam->print_value();
          MessageBox(0, "Not a floating point value", "Error", MB_ICONEXCLAMATION | MB_OK);
        }
        iam->editing = false;
      }
      break;

    case WM_KEYDOWN: 
      if (!iam->editing)
      {
        iam->backup_value();
        iam->editing = true;
      } 

      if (iam->editing && wParam == VK_RETURN)
      {
        if (iam->set_value())
        {
          iam->editing = false;
          SendMessage(iam->dlg, WM_COMMAND, MAKEWPARAM(iam->item, CB_ENTER), 0); 
        }
        else
          MessageBox(0, "Not a floating point value", "Error", MB_ICONEXCLAMATION | MB_OK);
        return 0; 
      }

      if (iam->editing && wParam == VK_ESCAPE)
      {
        iam->restore_value();
        iam->print_value();
        iam->editing = false;
        return 0;
      }

      break;
                            
    case WM_KEYUP: 
    case WM_CHAR: 
      switch (wParam) 
      { 
        case VK_RETURN: 
        case VK_ESCAPE: 
          return 0; 
      }
      break;

  } // switch  (msg)

  // Call the original window procedure for default processing. 
  return CallWindowProc(iam->wndproc, hwnd, msg, wParam, lParam); 
}

bool
DoubleEdit::set_value()
{
  char buf[256];
  char *stop;

  if (!SendDlgItemMessage(dlg, item, WM_GETTEXT, 256, (LONG)buf))
    return false;

  if (*buf == 0)
  {
    value = 0;
    return true;
  }

  double new_value = strtod(buf, &stop);
  if (*stop || errno == ERANGE) 
    return false;

  value = new_value;
  return true;
}

void
DoubleEdit::backup_value()
{
  old_value = value;
}

void 
DoubleEdit::restore_value()
{
  value = old_value;
}


void 
DoubleEdit::print_value()
{
  char buf[256];
  sprintf(buf, "%.4g", value);
  SetDlgItemText(dlg, item, buf);
}
