#ifndef AC3FILTER_H
#define AC3FILTER_H

#include <streams.h>
#include "ac3decoder.h"


const int blocks_per_sample = 6;
const int max_buffer_size = 256*2*6*blocks_per_sample;



class AC3Filter : 
  public CTransformFilter, 
  public DecoderControl
{
protected:
  acmod_t        speakers;
  int            input_sample_rate;

  IMediaSample  *sample;
  WORD          *sample_buffer;
  int            current_block;

  REFERENCE_TIME sample_time;
  bool           need_to_timestamp;

  WAVEFORMATEXTENSIBLE format;
  DWORD buffer_size;

  CCritSec data_flow;
  void new_sample();
  acmod_t default_speakers();

  /////////////////////////////////////////////////////////
  // CDecoder

  void block();

public:
  DECLARE_IUNKNOWN;
  static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);
  STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void **ppv);


  /////////////////////////////////////////////////////////
  // CTransformFilter

  HRESULT Transform(IMediaSample *pIn, IMediaSample *pOut);
  HRESULT CheckInputType(const CMediaType *mtIn);
  HRESULT CheckTransform(const CMediaType *mtIn,const CMediaType *mtOut);
  HRESULT GetMediaType(int iPosition, CMediaType *pMediaType);
  HRESULT SetMediaType(PIN_DIRECTION direction, const CMediaType *pmt);

  HRESULT DecideBufferSize(IMemAllocator *pAlloc,
                           ALLOCATOR_PROPERTIES *pProperties);

  /////////////////////////////////////////////////////////
  // IAC3Filter

  STDMETHODIMP set_speakers (acmod_t  _speakers);

private:
  AC3Filter(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
  ~AC3Filter();
};



#endif